#define WIN_INCLUDEALL
#include "windows.bi"
#include "resource.bi"

declare function WinMain ( _
	byval hInstance as hInstance, _
	byval hPrevInstance as hInstance, _
	byval lpCmdLine as LPSTR, _
	byval nCmdShow as integer ) as integer
end WinMain( GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"

dim shared as HFONT g_hfFont = NULL
dim shared as BOOL g_bOpaque = TRUE
dim shared as COLORREF g_rgbText = RGB(0, 0, 0)
dim shared as COLORREF g_rgbBackground = RGB(255, 255, 255)

dim shared as COLORREF g_rgbCustom(15)

sub DoSelectFont( byval hwnd as HWND )
	
	dim as CHOOSEFONT cf = type<CHOOSEFONT>(sizeof(CHOOSEFONT))
	dim as LOGFONT lf
	
	GetObject(g_hfFont, sizeof(LOGFONT), @lf)
	
	cf.Flags = CF_EFFECTS or CF_INITTOLOGFONTSTRUCT or CF_SCREENFONTS
	cf.hwndOwner = hwnd
	cf.lpLogFont = @lf
	cf.rgbColors = g_rgbText
	
	if( ChooseFont(@cf) <> 0 ) then
		dim as HFONT hf = CreateFontIndirect(@lf)
		if( hf <> 0 ) then	
			g_hfFont = hf
		else
			MessageBox(hwnd, "Font creation failed!", "Error", MB_OK or MB_ICONEXCLAMATION)
		end if
		
		g_rgbText = cf.rgbColors
	end if

end sub

sub DoSelectColour( byval hwnd as HWND )

	dim as CHOOSECOLOR cc = type<CHOOSECOLOR>(sizeof(CHOOSECOLOR))

	cc.Flags = CC_RGBINIT or CC_FULLOPEN or CC_ANYCOLOR
	cc.hwndOwner = hwnd
	cc.rgbResult = g_rgbBackground
	'' not sure about this line... make sure the array's declared properly, too
	cc.lpCustColors = @g_rgbCustom(0)

	if(ChooseColor(@cc) <> 0) then
		g_rgbBackground = cc.rgbResult
	end if
end sub

sub DrawClientSize( byval hdc as HDC, byval prc as RECT ptr, byval hf as HFONT )

	dim as string * 100 szSize
	dim as string szTitle = "These are the dimensions of your client area:"
	dim as HFONT hfOld = SelectObject(hdc, hf)

	SetBkColor(hdc, g_rgbBackground)
	SetTextColor(hdc, g_rgbText)

	if(g_bOpaque <> 0) then
		SetBkMode(hdc, OPAQUE)
	else
		SetBkMode(hdc, TRANSPARENT)
	end if

	DrawText(hdc, strptr(szTitle), -1, prc, DT_WORDBREAK)

	wsprintf(strptr(szSize), "{%d, %d, %d, %d}", prc->left, prc->top, prc->right, prc->bottom)
	DrawText(hdc, strptr(szSize), -1, prc, DT_SINGLELINE or DT_CENTER or DT_VCENTER)

	SelectObject(hdc, hfOld)
end sub

function WndProc( _
	byval hwnd as HWND, _
	byval msg as UINT, _
	byval wParam as WPARAM, _
	byval lParam as LPARAM) as LRESULT
	
	select case msg
		case WM_CREATE
			g_hfFont = GetStockObject(DEFAULT_GUI_FONT)
			
		case WM_CLOSE
			DestroyWindow(hwnd)
		
		case WM_COMMAND
			select case LOWORD(wParam)
				case ID_FILE_EXIT
					PostMessage(hwnd, WM_CLOSE, 0, 0)
					
				case ID_FORMAT_FONT
					DoSelectFont(hwnd)

					InvalidateRect(hwnd, NULL, TRUE)
					UpdateWindow(hwnd)
					
				case ID_FORMAT_DEFAULTGUIFONT
					DeleteObject(g_hfFont)
					g_hfFont = GetStockObject(DEFAULT_GUI_FONT)
					
					InvalidateRect(hwnd, NULL, TRUE)
					UpdateWindow(hwnd)
					
				case ID_FORMAT_TEST
				scope
					dim as HFONT hf
					dim as HDC hdc
					dim as long lfHeight
					
					hdc = GetDC(NULL)
					lfHeight = -MulDiv(12, GetDeviceCaps(hdc, LOGPIXELSY), 72)
					ReleaseDC(NULL, hdc)

					hf = CreateFont(lfHeight, 0, 0, 0, 0, TRUE, 0, 0, 0, 0, 0, 0, 0, "Times New Roman")

					if(hf <> 0) then
						DeleteObject(g_hfFont)
						g_hfFont = hf
					else
						MessageBox(hwnd, "Font creation failed!", "Error", MB_OK or MB_ICONEXCLAMATION)
					end if				
					InvalidateRect(hwnd, NULL, TRUE)
					UpdateWindow(hwnd)
				end scope
				
				case ID_FORMAT_BACKGROUNDCOLOUR
					DoSelectColour(hwnd)

					InvalidateRect(hwnd, NULL, TRUE)
					UpdateWindow(hwnd)
					
				case ID_FORMAT_OPAQUE
					g_bOpaque = not g_bOpaque

					InvalidateRect(hwnd, NULL, TRUE)
					UpdateWindow(hwnd)
			end select
			
		case WM_INITMENUPOPUP
			CheckMenuItem( cast( HMENU, wParam ), ID_FORMAT_OPAQUE, MF_BYCOMMAND or ( iif( g_bOpaque <> 0, MF_CHECKED, MF_UNCHECKED )))
			
		case WM_PAINT
		scope
			dim as RECT rcClient
			dim as PAINTSTRUCT ps
			dim as HDC hdc = BeginPaint(hwnd, @ps)

			GetClientRect(hwnd, @rcClient)

			DrawClientSize(hdc, @rcClient, g_hfFont)

			EndPaint(hwnd, @ps)
		end scope
		
		case WM_DESTROY
			DeleteObject(g_hfFont)

			PostQuitMessage(0)
			
		case else
			return DefWindowProc(hwnd, msg, wParam, lParam)
	end select
	return 0
end function


function WinMain ( _
	byval hInstance as hInstance, _
	byval hPrevInstance as hInstance, _
	byval lpCmdLine as LPSTR, _
	byval nCmdShow as integer ) as integer
	
	dim as WNDCLASSEX wc
	dim as HWND hwnd
	dim as MSG msg

  	with wc
	.cbSize        = sizeof(WNDCLASSEX)
	.style         = CS_VREDRAW or CS_HREDRAW
	.lpfnWndProc   = @WndProc()
	.cbClsExtra    = 0
	.cbWndExtra    = 0
	.hInstance     = hInstance
	.hIcon         = LoadIcon(NULL, IDI_APPLICATION)
	.hCursor       = LoadCursor(NULL, IDC_ARROW)
	.hbrBackground = cast(HBRUSH, (COLOR_WINDOW+1))
	'' originally IDR_MYMENU... might have accidentally deleted something
	.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU)
	.lpszClassName = strptr(g_szClassName)
	.hIconSm       = LoadIcon(NULL, IDI_APPLICATION)
	end with

	if( RegisterClassEx( @wc ) = 0 ) then
		MessageBox( NULL, "Window Registration Failed!", "Error!", _
			MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if

	hwnd = CreateWindowEx( _
		WS_EX_CLIENTEDGE, _
		g_szClassName, _
		"A Font Program", _
		WS_OVERLAPPEDWINDOW, _
		CW_USEDEFAULT, CW_USEDEFAULT, 240, 120, _
		NULL, NULL, hInstance, NULL ) 

	if ( hwnd = NULL ) then
		MessageBox(NULL, "Window Creation Failed!", "Error!", MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if

	ShowWindow( hwnd, nCmdShow )
	UpdateWindow( hwnd )

	while ( GetMessage( @Msg, NULL, 0, 0) > 0 )
		TranslateMessage(@Msg)
		DispatchMessage(@Msg)
	wend
	return Msg.wParam
end function